﻿Imports System.IO
Imports System.Drawing.Text
Imports BaiqiSoft.BarcodeControl


Friend Class frmDemo
    Inherits System.Windows.Forms.Form


    Private Sub ResetStatusBar()
        StatusBar.Items.Item("sb_Barcode").Text = "Barcode Size: " & MstBarcode1.BarcodeWidth & " x " & MstBarcode1.BarcodeHeight
    End Sub

    Private Sub frmDemo_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        'Barcode1.LicenseKey = "Enter Your License Key Here"

        'BarcodeType
        cboBarcodeType.Items.Add("EAN/JAN-13")
        cboBarcodeType.Items.Add("EAN/JAN-8")
        cboBarcodeType.Items.Add("Code39")
        cboBarcodeType.Items.Add("Code39Extended")
        cboBarcodeType.Items.Add("Code93")
        cboBarcodeType.Items.Add("Code93Extended")
        cboBarcodeType.Items.Add("Codabar")
        cboBarcodeType.Items.Add("Code128 Auto")
        cboBarcodeType.Items.Add("Code128A")
        cboBarcodeType.Items.Add("Code128B")
        cboBarcodeType.Items.Add("Code128C")
        cboBarcodeType.Items.Add("Code11")
        cboBarcodeType.Items.Add("UPCA")
        cboBarcodeType.Items.Add("UPCE")
        cboBarcodeType.Items.Add("Standard2of5")
        cboBarcodeType.Items.Add("Interleaved2of5")
        cboBarcodeType.Items.Add("UCC/EAN-128")
        cboBarcodeType.Items.Add("GS1-128")
        cboBarcodeType.Items.Add("PDF 417")
        cboBarcodeType.Items.Add("QRCode")
        cboBarcodeType.Items.Add("Aztec")
        cboBarcodeType.Items.Add("DataMatrix")
        cboBarcodeType.Items.Add("ITF-14")
        cboBarcodeType.Items.Add("ISBN/ISMN/ISSN")
        cboBarcodeType.Items.Add("Industrial2of5")
        cboBarcodeType.Items.Add("MSI/Plessey")
        cboBarcodeType.Items.Add("Telepen")
        cboBarcodeType.Items.Add("Postnet")
        cboBarcodeType.Items.Add("Pharmacode")
        cboBarcodeType.Items.Add("GS1 DataMatrix")
        cboBarcodeType.Items.Add("GS1 QRCode")
        cboBarcodeType.Items.Add("Micro QRCode")
        cboBarcodeType.Items.Add("Micro PDF417")
        cboBarcodeType.Items.Add("UCC/EAN-14")
        cboBarcodeType.Items.Add("SSCC-18")

        'Font Name
        Dim installedFontCollection As New InstalledFontCollection()
        Dim fontFamilies() As FontFamily = installedFontCollection.Families
        For i As Integer = 0 To fontFamilies.Length - 1
            cboFontName.Items.Add(fontFamilies(i).Name)
        Next i

        'FontSize
        For i As Integer = 5 To 72
            cboFontSize.Items.Add(CStr(i))
        Next i

        'LoadData
        txtBarcodeText.Text = MstBarcode1.Text
        cboBarcodeType.SelectedIndex = MstBarcode1.CodeType
        Select Case MstBarcode1.Rotate
            Case Rotate.None
                bt_Rotate.Image = bt_None.Image
            Case Rotate.Degree90
                bt_Rotate.Image = bt_Degree90.Image
            Case Rotate.Degree180
                bt_Rotate.Image = bt_Degree180.Image
            Case Rotate.Degree270
                bt_Rotate.Image = bt_Degree270.Image
        End Select
        bt_CheckSum.Checked = MstBarcode1.CheckSum
        bt_ShowText.Checked = MstBarcode1.ShowText
        Select Case MstBarcode1.TextAlignment
            Case BarcodeTextAlign.TopLeft
                bt_TextAlign.Image = bt_TopLeft.Image
            Case BarcodeTextAlign.TopCenter
                bt_TextAlign.Image = bt_TopCenter.Image
            Case BarcodeTextAlign.TopRight
                bt_TextAlign.Image = bt_TopRight.Image
            Case BarcodeTextAlign.TopExpand
                bt_TextAlign.Image = bt_TopExpand.Image
            Case BarcodeTextAlign.BottomLeft
                bt_TextAlign.Image = bt_BottomLeft.Image
            Case BarcodeTextAlign.BottomCenter
                bt_TextAlign.Image = bt_BottomCenter.Image
            Case BarcodeTextAlign.BottomRight
                bt_TextAlign.Image = bt_BottomRight.Image
            Case BarcodeTextAlign.BottomExpand
                bt_TextAlign.Image = bt_BottomExpand.Image
        End Select

        cboFontName.Text = MstBarcode1.FontName
        cboFontSize.Text = MstBarcode1.FontSize
        bt_FontBold.Checked = MstBarcode1.FontBold
        bt_FontItalic.Checked = MstBarcode1.FontItalic

        cboSupplementType.Text = MstBarcode1.SupplementType.ToString
        txtSupplement.Text = MstBarcode1.SupplementText
        txtLeftGap.Text = MstBarcode1.SupplementLeftGap
        txtTopGap.Text = MstBarcode1.SupplementTopGap

        ResetStatusBar()
        frmDemo_Resize(Me, EventArgs.Empty)

        MsgBox("The Font cannot be changed in the trial version.", MsgBoxStyle.Exclamation Or MsgBoxStyle.OkOnly, "Warning")
    End Sub

    Private Sub frmDemo_Resize(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Resize
        picFrame.Left = 0
        picFrame.Top = ToolBarFont.Top + ToolBarFont.Height
        picFrame.Width = Me.ClientRectangle.Width
        picFrame.Height = StatusBar.Top - picFrame.Top
        MstBarcode1.Left = picFrame.Left + 5
        MstBarcode1.Top = picFrame.Top + 5
        MstBarcode1.Width = picFrame.Width - 10
        MstBarcode1.Height = picFrame.Height - 10
    End Sub

    Private Sub txtBarcodeText_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles txtBarcodeText.TextChanged
        MstBarcode1.Text = txtBarcodeText.Text
    End Sub

    Private Sub cboFontSize_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cboFontSize.SelectedIndexChanged
        If cboFontName.Text.Length > 0 AndAlso cboFontSize.Text.Length > 0 AndAlso Convert.ToSingle(cboFontSize.Text) > 0 Then
            Dim fs As FontStyle = FontStyle.Regular
            If bt_FontBold.Checked Then
                fs = fs Or FontStyle.Bold
            End If
            If bt_FontItalic.Checked Then
                fs = fs Or FontStyle.Italic
            End If
            MstBarcode1.Font = New Font(cboFontName.Text, Convert.ToSingle(cboFontSize.Text), fs)
        End If
    End Sub

    Private Sub cboFontSize_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cboFontSize.TextChanged
        If cboFontName.Text.Length > 0 AndAlso cboFontSize.Text.Length > 0 AndAlso Convert.ToSingle(cboFontSize.Text) > 0 Then
            Dim fs As FontStyle = FontStyle.Regular
            If bt_FontBold.Checked Then
                fs = fs Or FontStyle.Bold
            End If
            If bt_FontItalic.Checked Then
                fs = fs Or FontStyle.Italic
            End If
            MstBarcode1.Font = New Font(cboFontName.Text, Convert.ToSingle(cboFontSize.Text), fs)
        End If
    End Sub

    Private Sub cboFontName_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cboFontName.SelectedIndexChanged
        If cboFontName.Text.Length > 0 AndAlso cboFontSize.Text.Length > 0 AndAlso Convert.ToSingle(cboFontSize.Text) > 0 Then
            Dim fs As FontStyle = FontStyle.Regular
            If bt_FontBold.Checked Then
                fs = fs Or FontStyle.Bold
            End If
            If bt_FontItalic.Checked Then
                fs = fs Or FontStyle.Italic
            End If
            MstBarcode1.Font = New Font(cboFontName.Text, Convert.ToSingle(cboFontSize.Text), fs)
        End If
    End Sub

    Private Sub cboFontName_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cboFontName.TextChanged
        If cboFontName.Text.Length > 0 AndAlso cboFontSize.Text.Length > 0 AndAlso Convert.ToSingle(cboFontSize.Text) > 0 Then
            Dim fs As FontStyle = FontStyle.Regular
            If bt_FontBold.Checked Then
                fs = fs Or FontStyle.Bold
            End If
            If bt_FontItalic.Checked Then
                fs = fs Or FontStyle.Italic
            End If
            MstBarcode1.Font = New Font(cboFontName.Text, Convert.ToSingle(cboFontSize.Text), fs)
        End If
    End Sub

    Private Sub cboBarcodeType_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cboBarcodeType.SelectedIndexChanged
        MstBarcode1.CodeType = cboBarcodeType.SelectedIndex
        MstBarcode1.Text = txtBarcodeText.Text
    End Sub

    Private Sub cboBarcodeType_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cboBarcodeType.TextChanged
        MstBarcode1.CodeType = cboBarcodeType.SelectedIndex
        MstBarcode1.Text = txtBarcodeText.Text
    End Sub

    Private Sub bt_FontBold_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_FontBold.Click
        If cboFontName.Text.Length > 0 AndAlso cboFontSize.Text.Length > 0 AndAlso Convert.ToSingle(cboFontSize.Text) > 0 Then
            Dim fs As FontStyle = FontStyle.Regular
            If bt_FontBold.Checked Then
                fs = fs Or FontStyle.Bold
            End If
            If bt_FontItalic.Checked Then
                fs = fs Or FontStyle.Italic
            End If
            MstBarcode1.Font = New Font(cboFontName.Text, Convert.ToSingle(cboFontSize.Text), fs)
        End If
    End Sub

    Private Sub bt_FontItalic_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_FontItalic.Click
        If cboFontName.Text.Length > 0 AndAlso cboFontSize.Text.Length > 0 AndAlso Convert.ToSingle(cboFontSize.Text) > 0 Then
            Dim fs As FontStyle = FontStyle.Regular
            If bt_FontBold.Checked Then
                fs = fs Or FontStyle.Bold
            End If
            If bt_FontItalic.Checked Then
                fs = fs Or FontStyle.Italic
            End If
            MstBarcode1.Font = New Font(cboFontName.Text, Convert.ToSingle(cboFontSize.Text), fs)
        End If
    End Sub

    Private Sub bt_CheckSum_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_CheckSum.Click
        MstBarcode1.CheckSum = bt_CheckSum.Checked
    End Sub

    Private Sub bt_ShowText_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_ShowText.Click
        MstBarcode1.ShowText = bt_ShowText.Checked
    End Sub


    Private Sub bt_ShowIndicator_Click(sender As System.Object, e As System.EventArgs) Handles bt_ShowIndicator.Click
        MstBarcode1.ShowIndicator = bt_ShowIndicator.Checked
    End Sub

    Private Sub bt_ShowStartStopChar_Click(sender As System.Object, e As System.EventArgs) Handles bt_ShowStartStopChar.Click
        MstBarcode1.ShowStartStopChar = bt_ShowStartStopChar.Checked
    End Sub

    Private Sub bt_TopLeft_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_TopLeft.Click
        MstBarcode1.TextAlignment = BarcodeTextAlign.TopLeft
        bt_TextAlign.Image = bt_TopLeft.Image
    End Sub

    Private Sub bt_TopCenter_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_TopCenter.Click
        MstBarcode1.TextAlignment = BarcodeTextAlign.TopCenter
        bt_TextAlign.Image = bt_TopCenter.Image
    End Sub

    Private Sub bt_TopRight_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_TopRight.Click
        MstBarcode1.TextAlignment = BarcodeTextAlign.TopRight
        bt_TextAlign.Image = bt_TopRight.Image
    End Sub

    Private Sub bt_TopExpand_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_TopExpand.Click
        MstBarcode1.TextAlignment = BarcodeTextAlign.TopExpand
        bt_TextAlign.Image = bt_TopExpand.Image
    End Sub

    Private Sub bt_BottomLeft_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_BottomLeft.Click
        MstBarcode1.TextAlignment = BarcodeTextAlign.BottomLeft
        bt_TextAlign.Image = bt_BottomLeft.Image
    End Sub

    Private Sub bt_BottomCenter_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_BottomCenter.Click
        MstBarcode1.TextAlignment = BarcodeTextAlign.BottomCenter
        bt_TextAlign.Image = bt_BottomCenter.Image
    End Sub

    Private Sub bt_BottomRight_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_BottomRight.Click
        MstBarcode1.TextAlignment = BarcodeTextAlign.BottomRight
        bt_TextAlign.Image = bt_BottomRight.Image
    End Sub

    Private Sub bt_BottomExpand_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_BottomExpand.Click
        MstBarcode1.TextAlignment = BarcodeTextAlign.BottomExpand
        bt_TextAlign.Image = bt_BottomExpand.Image
    End Sub

    Private Sub bt_None_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_None.Click
        MstBarcode1.Rotate = Rotate.None
        bt_Rotate.Image = bt_None.Image
    End Sub

    Private Sub bt_Degree90_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_Degree90.Click
        MstBarcode1.Rotate = Rotate.Degree90
        bt_Rotate.Image = bt_Degree90.Image
    End Sub

    Private Sub bt_Degree180_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_Degree180.Click
        MstBarcode1.Rotate = Rotate.Degree180
        bt_Rotate.Image = bt_Degree180.Image
    End Sub

    Private Sub bt_Degree270_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_Degree270.Click
        MstBarcode1.Rotate = Rotate.Degree270
        bt_Rotate.Image = bt_Degree270.Image
    End Sub

    Private Sub bt_BackColor_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_BackColor.Click
        ColorDialog1.Color = MstBarcode1.BackColor
        ColorDialog1.ShowDialog()
        MstBarcode1.BackColor = ColorDialog1.Color
    End Sub

    Private Sub bt_ForeColor_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_ForeColor.Click
        ColorDialog1.Color = MstBarcode1.ForeColor
        ColorDialog1.ShowDialog()
        MstBarcode1.ForeColor = ColorDialog1.Color
    End Sub

    Private Sub bt_Layout_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles bt_Layout.Click
        frmLayout.ShowDialog()
        ResetStatusBar()
    End Sub

    Private Sub mm_Help_HelpOnline_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mm_Help_HelpOnline.Click
        MstBarcode.OpenWebLink("http://www.mysofttool.com/help/mstbarcode")
    End Sub

    Private Sub mm_Help_CheckUpdates_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mm_Help_CheckUpdates.Click
        MstBarcode.OpenWebLink("http://www.mysofttool.com")
    End Sub

    Private Sub mm_Help_PurchaseNow_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mm_Help_PurchaseNow.Click
        MstBarcode.OpenWebLink("http://www.mysofttool.com/purchase/")
    End Sub

    Private Sub mm_Help_About_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mm_Help_About.Click
        MstBarcode1.AboutBox()
    End Sub

    Private Sub cboSupplementType_SelectedIndexChanged(sender As Object, e As System.EventArgs) Handles cboSupplementType.SelectedIndexChanged
        MstBarcode1.SupplementType = cboSupplementType.SelectedIndex
    End Sub

    Private Sub txtSupplement_TextChanged(sender As Object, e As System.EventArgs) Handles txtSupplement.TextChanged
        MstBarcode1.SupplementText = txtSupplement.Text
    End Sub

    Private Sub txtLeftGap_TextChanged(sender As Object, e As System.EventArgs) Handles txtLeftGap.TextChanged
        MstBarcode1.SupplementLeftGap = Val(txtLeftGap.Text)
    End Sub

    Private Sub txtTopGap_TextChanged(sender As Object, e As System.EventArgs) Handles txtTopGap.TextChanged
        MstBarcode1.SupplementTopGap = Val(txtTopGap.Text)
    End Sub

    Private Sub btnDllSample_Click(sender As System.Object, e As System.EventArgs) Handles btnDllSample.Click
        frmDllSample.ShowDialog()
    End Sub
End Class
